<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Content-Type: application/json; charset=UTF-8");

// Handle errors gracefully so they don't break JSON
try {
    require __DIR__ . '/classes/Database.php';

    $db = new Database();
    $pdo = $db->dbConnection();

    // Select doctors from DB
    $stmt = $pdo->prepare("SELECT * FROM doctors ORDER BY id DESC");
    $stmt->execute();
    
    $doctors = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($doctors);

} catch (Exception $e) {
    // Return error as JSON, not HTML
    echo json_encode(["error" => $e->getMessage()]);
}
?>
